 var sbctx = new SP.ClientContext.get_current();  
 var sbweb = sbctx.get_web();  
 var formsstorelibrary = 'FormsStoreLibrary';
 var exportedformsfolder = 'ExportedForms';

function LoadScript  (src, callback) {
    var s, r;
    r = false;
    s = document.createElement('script');
    s.type = 'text/javascript';
    s.src = src.toLowerCase();
    s.async = false;
    s.onload = s.onreadystatechange = function () {
		if (!r && (!this.readyState || this.readyState == 'complete' || this.readyState == 'loaded')) {
			r = true;
			callback(s);
		}
    };
    var t = document.getElementsByTagName('head')[0];
    t.appendChild(s);
};


function PerformImportProvisioning(formContent,formUrl,successCallback){
    formContent = NormalizeFormContent(formContent);
    var template = JSON.parse(formContent);
    _spPageContextInfo.serverRequestPath = _spPageContextInfo.webServerRelativeUrl + formUrl;
    var provisioning = Ardevia.skybow.Provisioning; 
    var ins = new provisioning.JSOM.ProvisioningTemplateHandler(new provisioning.JSOM.ContextProvider(null, _spPageContextInfo.webServerRelativeUrl), [new provisioning.JSOM.RichForms.ArdeviaRichFormsPageHandler()]);                                        
    template.Elements['Pages'][0].ServerRelativeUrl = _spPageContextInfo.webServerRelativeUrl != '/' ? _spPageContextInfo.serverRequestPath.substring(_spPageContextInfo.webServerRelativeUrl.length) : _spPageContextInfo.serverRequestPath;
    ins.ApplyTemplate(template).done(function () {
        successCallback();
    });
}

function NormalizeFormContent(formContent){     
    var validJsonString = '';
    for (var x = 0; x < formContent.length; x++)
    {
        var char = formContent.charAt(x);
        try {
            if( char == '"' || char == "'" || char == "\\" ){
                validJsonString += char;
                continue;    
            }
            JSON.parse('{"some":"'+ char +'"}');
            validJsonString += char;
        } catch (e) { 
            console.log('(!) ' + char + ' - character is not valid for JSON');                   
        }
    }
    return validJsonString;        
}

function LoadExportedForms(successCallback){    
    var lib = sbweb.get_lists().getByTitle(formsstorelibrary);
    var query = SP.CamlQuery.createAllItemsQuery();
    var folderServerRelativeUrl = _spPageContextInfo.webServerRelativeUrl + '/' + formsstorelibrary + '/' + exportedformsfolder;
    query.set_folderServerRelativeUrl(folderServerRelativeUrl);
    var files = lib.getItems(query);
    sbctx.load(files, 'Include(Title, ContentType, File)');
    sbctx.executeQueryAsync(function(){
        var filesEnumerator = files.getEnumerator();
        var defers = [];
        var formsInfo = [];
        while(filesEnumerator.moveNext()){
            var file = filesEnumerator.get_current();
            var itemContentType = file.get_contentType();
            if(itemContentType.get_name() != 'Folder'){
                var formName = file.get_file().get_name();                                              
                var fileServerRelativeUrl = folderServerRelativeUrl + '/' + formName;                                                                 
                var promise = ArdeviaJQuery.get(fileServerRelativeUrl, function(filecontent) {                    
                    var fromUrl = filecontent.split('||')[0];
                    filecontent = filecontent.replace(fromUrl+'||','');
                    formsInfo.push({
                        content:filecontent,
                        url:fromUrl
                    });
                });
                defers.push(promise);
            }
        }        
        ArdeviaJQuery.when.apply(ArdeviaJQuery, defers).then(function () {            
            successCallback(formsInfo);
        });    
    },function(sender, args){
        console.log('(-) LoadExportedForms FAILED:(Can not load files) ' + args.get_message() + '\n' + args.get_stackTrace());            
    });
}

function ImportForms(){        
      LoadExportedForms(function(forms){          
          var formsCount = forms.length;
          if(!formsCount) return console.log('(-) ImportForms FAILED: There are not any forms into folder ' + exportedformsfolder);  
          console.log('(+) ImportForms : ' + formsCount + ' forms must be imported');  
          for(var i=0; i<forms.length; i++){
            var formContent = forms[i].content;
            var formUrl = forms[i].url;
            if(!formContent || !formUrl){
                console.log('(-) ImportForms WARNING: Some form content into ' + exportedformsfolder +' folder is not proper');  
                continue;
            } 
            PerformImportProvisioning(formContent,formUrl,function(){
                console.log('(+) Form  IMPORTED');   
            });
          }
      })
}

LoadScript(_spPageContextInfo.webAbsoluteUrl + '/FormsStoreLibrary/Scripts/jquery-1.10.2.min.js', function(){
    if(!ArdeviaJQuery) return console.log('(-) LoadScript FAILED (ArdeviaJQuery): jquery-1.10.2.min.js not loaded');  
    LoadScript(_spPageContextInfo.webAbsoluteUrl + '/FormsStoreLibrary/Scripts/skybow_provisioning.js',function(){
        if(!Ardevia.skybow || !Ardevia.skybow.Provisioning || !Ardevia.skybow.Provisioning.JSOM)
            return console.log('(-) LoadScript FAILED: skybow_provisioning.js not loaded'); 
        ImportForms();
    });	
});	

