 var sbctx = new SP.ClientContext.get_current();  
 var sbweb = sbctx.get_web();  
 var formsstorelibrary = 'FormsStoreLibrary';
 var exportedformsfolder = 'ExportedForms';
 var sbColRelativeUrl = 'RelativeUrl';

function CreateFile(filename,filecontent,successCallback,errorCallback){
    if(!filename) {
      console.log('(-) CreateFile FAILED: File name dose not exsist');    
      return errorCallback();
    } 
    
    var lib = sbweb.get_lists().getByTitle(formsstorelibrary);        
    this.folders = lib.get_rootFolder().get_folders();
    sbctx.load(this.folders);
    sbctx.executeQueryAsync(function(){
        var folder ;
        var foldersEnumerator = folders.getEnumerator();       
        while(foldersEnumerator.moveNext()){            
            var currentFolder = foldersEnumerator.get_current();
            if(currentFolder.get_name() === exportedformsfolder){
                folder = currentFolder;
                break;
            }
        }        
        if(!folder) {
          console.log('(-) CreateFile FAILED: Folder with name '+ exportedformsfolder +' dose not exsist into ' + formsstorelibrary);     
          return errorCallback();
        }
        var fileinfo = new SP.FileCreationInformation();  
        fileinfo.set_url(filename);  
        fileinfo.set_content(new SP.Base64EncodedByteArray());   
        for (var i = 0; i < filecontent.length; i++)   
        {  
            fileinfo.get_content().append(filecontent.charCodeAt(i));  
        }
        var file = folder.get_files().add(fileinfo);  
        sbctx.load(file);  
        sbctx.executeQueryAsync(function(){
            console.log('(+) File ' + filename + ' CREATED in folder ' + exportedformsfolder);   
            successCallback();     
        },function(sender, args){
            console.log('(-) CreateFile FAILED: ' + args.get_message() + '\n' + args.get_stackTrace());        
            errorCallback();
        });    

    },function(sender, args){
        console.log('(-) CreateFile FAILED:(Can not load folders) ' + args.get_message() + '\n' + args.get_stackTrace());        
        errorCallback();
    });
    
}

function CreateFolder(successCallback) {         
    var lib = sbweb.get_lists().getByTitle(formsstorelibrary);    
    var folder = new SP.ListItemCreationInformation();  
    folder.set_underlyingObjectType(SP.FileSystemObjectType.folder);  
    folder.set_leafName(exportedformsfolder);  
    var folderListItem = lib.addItem(folder);  
    folderListItem.update();    
    sbctx.load(folderListItem);  
    sbctx.executeQueryAsync(function(){          
        successCallback();     
    },function(sender, args){
        console.log('(-) CreateFolder FAILED: ' + args.get_message() + '\n' + args.get_stackTrace());        
    });    
}  

function LoadFormsStoreListItems (successCallback){			
	var storeList = sbweb.get_lists().getByTitle(formsstorelibrary);
	var allCustomizedFormsQuery = new SP.CamlQuery();			
	allCustomizedFormsQuery.set_viewXml('' +
	'<View>'+
		'<Query>'+
			'<Where>'+				
				'<And>'+
					 '<IsNotNull>'+  
						'<FieldRef Name="'+sbColRelativeUrl+'" />'+   
					 '</IsNotNull>'+  
					 '<Neq>'+  
						'<FieldRef Name="'+sbColRelativeUrl+'" />'+  
						'<Value Type="Text"></Value>'+  
					 '</Neq>'+
				'</And>'+
			'</Where>'+
		'</Query>'+
	'</View>');

	var items = storeList.getItems(allCustomizedFormsQuery);
	sbctx.load(items);		
    sbctx.executeQueryAsync(function(sender, args) {				
		successCallback(items);		
    }, function(sender, args) {				
		console.log('(-) LoadFormsStoreListItems FAILED: ' + args.get_message() + '\n' + args.get_stackTrace()); 
    });
}

function LoadScript  (src, callback) {
    var s, r;
    r = false;
    s = document.createElement('script');
    s.type = 'text/javascript';
    s.src = src.toLowerCase();
    s.async = false;
    s.onload = s.onreadystatechange = function () {
		if (!r && (!this.readyState || this.readyState == 'complete' || this.readyState == 'loaded')) {
			r = true;
			callback(s);
		}
    };
    var t = document.getElementsByTagName('head')[0];
    t.appendChild(s);
};

function PerformExportProvisioning(itemRelativeUrl,successCallback,errorCallback){        
            var provisioning = Ardevia.skybow.Provisioning;        
            var ctxProvider = new provisioning.JSOM.ContextProvider(null, _spPageContextInfo.webServerRelativeUrl);
            var t = new provisioning.JSOM.ProvisioningTemplateHandler(ctxProvider, [new provisioning.JSOM.RichForms.ArdeviaRichFormsPageHandler()]);                
            _spPageContextInfo.serverRequestPath = _spPageContextInfo.webServerRelativeUrl + itemRelativeUrl;
            t.GetWebTemplate(function (template) {                                                
                var pageUrlParts = _spPageContextInfo.serverRequestPath.split('/');
                var formName = pageUrlParts[pageUrlParts.length - 1].split('.')[0];
                var listName = pageUrlParts[pageUrlParts.length - 2];
                var listInternalName = listName.toLowerCase() === 'forms' ? pageUrlParts[pageUrlParts.length - 3] : listName;                    
                var filename =  listInternalName + '_' + formName + '.txt';
                var filecontent = JSON.stringify(template);                            
                successCallback(filename,filecontent);
            }, {
                Type: "ONLY",
                Options: {
                Pages: [
                    {
                        Schema: { ServerRelativeUrl:_spPageContextInfo.serverRequestPath }
                    }
                ]
            }
            });      
}

function HandleItem(itemEnumerator){
    if(itemEnumerator.moveNext()){        
        var item = itemEnumerator.get_current();
        var itemRelativeUrl = item.get_item(sbColRelativeUrl);                
        PerformExportProvisioning(itemRelativeUrl,function(filename,filecontent){            
             filecontent =  itemRelativeUrl + '||' + filecontent;
             CreateFile(filename,filecontent,function(){                 		
                 HandleItem(itemEnumerator);
             },function(){
                 HandleItem(itemEnumerator);
             });
        });
    }
}

function HandleItemsRecursively(itemEnumerator){
    HandleItem(itemEnumerator);
}

function ExportForms(){      
    LoadFormsStoreListItems(function(items){
        var itemsCount = items.get_count();
        if (itemsCount === 0)  return console.log('(-) ExportForms FAILED: There arent any customized forms in library');  		       
        console.log('(+) ExportForms: ' + itemsCount  + ' items must be exported to folder ' + exportedformsfolder);  		
        CreateFolder(function(){       
            HandleItemsRecursively(items.getEnumerator());
        });
    });    
}


LoadScript(_spPageContextInfo.webAbsoluteUrl + '/FormsStoreLibrary/Scripts/skybow_provisioning.js',function(){
    if(!Ardevia.skybow || !Ardevia.skybow.Provisioning || !Ardevia.skybow.Provisioning.JSOM)
        return console.log('(-) LoadScript FAILED: skybow_provisioning.js not loaded'); 
    ExportForms();
});	