var sbctx = new SP.ClientContext(_spPageContextInfo.webAbsoluteUrl);
var sbweb = sbctx.get_web();

var sbColListId = 'ListId';
var sbColFormType = 'FormType';
var sbColRelativeUrl = 'RelativeUrl';
	
var sbJsLinksForUpdate = ['/FormsStoreLibrary/Scripts/jquery-1.10.2.min.js', '/FormsStoreLibrary/Scripts/ArdeviaRichFormsLoader.js']; 

 var formsstorelibrary = 'FormsStoreLibrary';

function GetListIdByRelativeUrl(formRelativeUrl,lists){
	
	var listEnumerator = lists.getEnumerator();
	while (listEnumerator.moveNext()) {
		var list = listEnumerator.get_current();	
		var listTitle = list.get_title();	
		var rootFolderUrl = list.get_rootFolder().get_serverRelativeUrl()
		var listTitleFromUrl = formRelativeUrl.split('/')[2];		
		if(rootFolderUrl && listTitleFromUrl && listTitle && ( listTitle === rootFolderUrl || rootFolderUrl.indexOf(listTitleFromUrl) != -1)) {
			return '{' + list.get_id() + '}';
		}	
	}
	
	return '';
}

function FixJsLinks(){	
	LogMsg('Working on it ... ');

	var lists = sbweb.get_lists();   
    sbctx.load(lists, 'Include(Title, Id, RootFolder)');		
	
	LoadFormsStoreListItems(function(customizedFormsItems){
		if(customizedFormsItems.length){
			console.log('(!)(SRF) '+customizedFormsItems.length+' forms must be updated ');	
			for(var i=0;i<customizedFormsItems.length;i++){		
				
				var formUrl = customizedFormsItems[i].RelativeUrl;
				var listId = GetListIdByRelativeUrl(formUrl,lists);						
				if(listId){					
					var webpartsContainer = [];
					LoadWebParts(webpartsContainer,formUrl,function(loadedWebParts){
						ProcessFormWebParts(loadedWebParts, listId );											
						sbctx.executeQueryAsync(function () {
							console.log('(!)(SRF) form successfully updated ')
						}, function (s, e) {
							LogMsg('ProcessFormWebParts FAILED');
						});
					},function(s,e){					
						LogMsg('LoadWebParts FAILED');
					});
				}				
			}											 
		}														
	});	
}

function LoadFormsStoreListItems (successCallback){			
	var storeList = sbweb.get_lists().getByTitle(formsstorelibrary);
	var allCustomizedFormsQuery = new SP.CamlQuery();			
	allCustomizedFormsQuery.set_viewXml('' +
	'<View>'+
		'<Query>'+
			'<Where>'+				
				'<And>'+
					 '<IsNotNull>'+  
						'<FieldRef Name="'+sbColRelativeUrl+'" />'+   
					 '</IsNotNull>'+  
					 '<Neq>'+  
						'<FieldRef Name="'+sbColRelativeUrl+'" />'+  
						'<Value Type="Text"></Value>'+  
					 '</Neq>'+
				'</And>'+
			'</Where>'+
		'</Query>'+
	'</View>');

	var items = storeList.getItems(allCustomizedFormsQuery);
	sbctx.load(items);		
    sbctx.executeQueryAsync(function(sender, args) {		
		  var sbAllCustomizedFormsItems = [];
			if (items.get_count() > 0){
				for(var i=0; i<items.get_count(); i++){
					var item = items.get_item(i);
					sbAllCustomizedFormsItems.push({						
						RelativeUrl: item.get_item(sbColRelativeUrl)
					});
				}				
			}                
            else
                allCustomizedFormsItems = null;   
			
			successCallback(sbAllCustomizedFormsItems);	
						
    }, function(sender, args) {				
		console.log('(-) LoadFormsStoreListItems FAILED: ' + args.get_message() + '\n' + args.get_stackTrace()); 
    });
}

	function LoadWebParts(webparts,formUrl, webpartsLoadedCallback, failedCallback){		
		sbctx.load(sbweb,'ServerRelativeUrl');
		sbctx.executeQueryAsync(function () {			  
			var relativeWebUrl = sbweb.get_serverRelativeUrl();
			relativeWebUrl = relativeWebUrl === '/' ? '' : relativeWebUrl;
			formUrl = relativeWebUrl + formUrl;
			var file = sbweb.getFileByServerRelativeUrl(formUrl);
			var listItemRelatedToPage = file.get_listItemAllFields();
			sbctx.load(listItemRelatedToPage);
			var limitedWebPartManager = file.getLimitedWebPartManager(SP.WebParts.PersonalizationScope.shared);
			var collWebPart = limitedWebPartManager.get_webParts();
			sbctx.load(collWebPart);				
			sbctx.executeQueryAsync(function () {				 
				 ProcessWebParts(webparts,collWebPart,webpartsLoadedCallback, failedCallback);
			 }, function (s, e) {				         
				failedCallback(s,e);
			 });		
		}, function (s, e) {			
			failedCallback(s,e);
		});
	}

	function ProcessWebParts(webparts,collWebPart,webpartsLoadedCallback, webPartDefFailed){
		var collWebPartsEnumerator = collWebPart.getEnumerator();
		HandleNextWebPart(webparts,collWebPartsEnumerator,webpartsLoadedCallback, webPartDefFailed);
	}

	function HandleNextWebPart(webparts,collWebPartsEnumerator,webpartsLoadedCallback, webPartDefFailed){ 
		if (collWebPartsEnumerator.moveNext()) {
			var webPartDefinition = collWebPartsEnumerator.get_current();
			var webPart = webPartDefinition.get_webPart();
			sbctx.load(webPart, 'Properties', 'ZoneIndex', 'Title');
			sbctx.executeQueryAsync(function (sender, args) {		
				var webPartInfo = {WebPart:webPart, WebPartDefinition:webPartDefinition};
				webparts.push(webPartInfo);
				HandleNextWebPart(webparts,collWebPartsEnumerator, webpartsLoadedCallback, webPartDefFailed);				
			}, function (s,a) { 	
				webPartDefFailed(s,a);            
				HandleNextWebPart(webparts,collWebPartsEnumerator, webpartsLoadedCallback, webPartDefFailed);
			});
		}else{
			webpartsLoadedCallback(webparts); 
		}
	}

	function ProcessFormWebParts(webparts, listId ){
		HandleNextFormWebParts(webparts, listId );
	}
	
	function HandleNextFormWebParts(webparts, listId ){
		for (var i = 0; i < webparts.length; i++) {        
			var webPart = webparts[i].WebPart;
			var webPartDefinition = webparts[i].WebPartDefinition;                    
			HandleFormWebPart(webPart, webPartDefinition, listId );        
		}		
	}
	
	function HandleFormWebPart(webPart, webPartDefinition, listId ){
		try {
			var props = webPart.get_properties();           			
			var jsLink = CheckWebPartProperty(props, 'JSLink');			
						
			var isRFjsLinkAlreadySet = jsLink && jsLink.toLowerCase().indexOf("jquery-1.10.2.min.js".toLowerCase()) !== -1 && jsLink.toLowerCase().indexOf("ArdeviaRichFormsLoader.js".toLowerCase()) !== -1 ;
			if (isRFjsLinkAlreadySet) {
				var jsLinksForSet = ComposeJSLink();			
				InsertJsLink(jsLink, jsLinksForSet, props,  webPartDefinition);				 	
			}
						
		}catch (ex) {
			LogMsg("HandleFormWebPart FAILED");			 
		}
			
	}
	
	function CheckWebPartProperty(props, propName){;
		try {
			return props.get_item(propName);
		}catch (e) {
			return null;
		}
	}
	
	function ComposeJSLink(){		
		var jsLinksForSet = sbJsLinksForUpdate.reduce(function (base, next) { return base + '~site' + next + '?v=1|'; }, '');	
		jsLinksForSet = jsLinksForSet.substring(0, jsLinksForSet.length - 1);
		return jsLinksForSet;
	}
	
	function InsertJsLink(jsLink, jsLinksForSet, props, webPartDefinition){		
		if(IsFormWebPart(props)){
			try{
				props.set_item('JSLink', jsLinksForSet);			 
				webPartDefinition.saveWebPartChanges();
			}catch(ex){
				LogMsg("InsertJsLink FAILED");
			}
		}		
	}

	function IsFormWebPart(webPartProperties){
		var type = CheckWebPartProperty(webPartProperties, 'FormType');
		var mode = CheckWebPartProperty(webPartProperties, 'ControlMode');
		return type && mode;
	}
	
	function LogMsg (msg){
		console.log(" (!) " + msg);
	}
	 
	 FixJsLinks();