define("sbEnumConverter", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var EnumConverter = /** @class */ (function () {
        function EnumConverter() {
        }
        EnumConverter.GetEnumString = function (enumClass, key) {
            return enumClass[key];
        };
        return EnumConverter;
    }());
    exports.EnumConverter = EnumConverter;
});

define("sbLoadingNotification", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var LoadingNotification = /** @class */ (function () {
        function LoadingNotification() {
        }
        LoadingNotification.prototype.Show = function () {
            this.Remove();
            LoadingNotification.notificationHandler = SP.UI.Notify.showLoadingNotification(true);
        };
        LoadingNotification.prototype.Remove = function () {
            SP.UI.Notify.removeNotification(LoadingNotification.notificationHandler);
        };
        return LoadingNotification;
    }());
    exports.LoadingNotification = LoadingNotification;
});

define("sbStatusColors", ["require", "exports"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var StatusColors;
    (function (StatusColors) {
        StatusColors[StatusColors["red"] = 0] = "red";
        StatusColors[StatusColors["yellow"] = 1] = "yellow";
        StatusColors[StatusColors["green"] = 2] = "green";
        StatusColors[StatusColors["blue"] = 3] = "blue";
        StatusColors[StatusColors["grey"] = 4] = "grey";
    })(StatusColors = exports.StatusColors || (exports.StatusColors = {}));
});

define("sbStatus", ["require", "exports", "sbStatusColors", "sbEnumConverter"], function (require, exports, StatusColors_1, EnumConverter_2) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var Status = /** @class */ (function () {
        function Status(Title, Message, showOnTop) {
            if (showOnTop === void 0) { showOnTop = false; }
            this.Title = Title;
            this.Message = Message;
            this.showOnTop = showOnTop;
        }
        Status.prototype.SetColor = function (color) {
            this.color = color;
        };
        Status.prototype.Show = function () {
            if (this.messageId == null) {
                if (SP.UI.Status)
                    this.messageId = SP.UI.Status.addStatus(this.Title, this.Message, this.showOnTop);
                //   SP.UI.Notify.removeNotification(this.messageId);
            }
            if (this.color != null && SP.UI.Status) {
                var value = EnumConverter_2.EnumConverter.GetEnumString(StatusColors_1.StatusColors, this.color);
                SP.UI.Status.setStatusPriColor(this.messageId, value);
            }
            return this.messageId;
        };
        Status.prototype.ShowWithTimer = function (time) {
            var _this = this;
            setTimeout(function () {
                _this.Remove();
            }, time);
            return this.Show();
        };
        Status.prototype.Remove = function () {
            SP.UI.Status.removeStatus(this.messageId);
        };
        Status.RemoveAllStatus = function () {
            SP.UI.Status.removeAllStatus(true);
        };
        Status.Error = function (title, message, showOnTop, timer) {
            if (showOnTop === void 0) { showOnTop = false; }
            var status = new Status(title, message, showOnTop);
            status.SetColor(StatusColors_1.StatusColors.red);
            return timer ? status.ShowWithTimer(timer) : status.Show();
        };
        Status.Warning = function (title, message, showOnTop, timer) {
            if (showOnTop === void 0) { showOnTop = false; }
            var status = new Status(title, message, showOnTop);
            status.SetColor(StatusColors_1.StatusColors.yellow);
            return timer ? status.ShowWithTimer(timer) : status.Show();
        };
        Status.Info = function (title, message, showOnTop, timer) {
            if (showOnTop === void 0) { showOnTop = false; }
            var status = new Status(title, message, showOnTop);
            status.SetColor(StatusColors_1.StatusColors.blue);
            return timer ? status.ShowWithTimer(timer) : status.Show();
        };
        Status.Success = function (title, message, showOnTop, timer) {
            if (showOnTop === void 0) { showOnTop = false; }
            var status = new Status(title, message, showOnTop);
            status.SetColor(StatusColors_1.StatusColors.green);
            return timer ? status.ShowWithTimer(timer) : status.Show();
        };
        Status.Update = function (sid, text) {
            SP.UI.Status.updateStatus(sid, text);
        };
        return Status;
    }());
    exports.Status = Status;
});

define("sbExecuteCustomLogicConfigVM", ["require", "exports", "knockout", "jquery"], function (require, exports, ko, jQuery) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CustomActionConfigVM = /** @class */ (function () {
        function CustomActionConfigVM(actionData) {
			this.ActionData = actionData;
            this.TemplateFileName = "CustomActionTemplate";
            this.MapPropertyToObservable('Title');
            this.MapPropertyToObservable('Condition');
            this.MapPropertyToObservable('ActionType');
            this.MapPropertyToObservable('Message');
            this.IsValid = ko.computed(function () {
                return true;
            }, this);
            this.IconUrl = ko.computed(function () {
                return null;
            });
            this.ActionDisabledIconUrl = ko.observable(null);
            this.ErrorIconUrl = ko.observable(null);
            this.TemplateLoaded = ko.observable(true);
            this.Errors = ko.observable(ko.validation.group(this));
            var _this = this;
            return _this;
        }

        CustomActionConfigVM.prototype.LoadTemplate = function () {
            var html = "<script id=\"CustomActionTemplate\" type=\"text/html\">" +
                            "<table class=\"skybow-actions-table\">" +
                                "<tr>" +
                                    "<td>" +
                                        "<label for=\"sbMessage\">Message:</label>"+
                                    "</td>" +
                                    "<td>" +
                                        "<div class=\"skybow-actions-expr-column\">" +
                                            "<div class=\"skybow-actions-expr-field-cont\">" +
                                                "<input type=\"text\" class=\"skybow-action-input skybow-actions-fullwidth-input\" id=\"sbMessage\" data-bind=\"value: Message, valueUpdate: 'afterkeydown'\"/>" +
                                            "</div>" +
                                            "<button type=\"button\" class=\"skybow-actions-expr-editor-icon\" data-bind=\"click: function (event, data) { $root.EditInExpressionBuilder($data.Message, 'Message'); }\" title=\"Edit In Expression Builder\"/>" +
                                        "</div>" +
                                    "</td>" +
                                "</tr>" +
                            "</table>" +
                        "</script>";
            jQuery(window.top.document.body).append(html);
            this.TemplateLoaded(true);
            this.OnTemplateLoaded();
        };

        CustomActionConfigVM.prototype.GetDocumentationURL = function (baseUrl) {

        };

        CustomActionConfigVM.prototype.InitViewModels = function () {
  
        };
        
        CustomActionConfigVM.prototype.SetupValidation = function () {
            this.ActionType.extend({
                required: {
                    params: true,
                    message: 'Action Type must be selected'
                }
            });
            this.Errors(ko.validation.group(this, options));
        };
        CustomActionConfigVM.prototype.PrepareDataForSave = function () {

        };

        CustomActionConfigVM.prototype.InitializeTemplate = function () {
            this.LoadTemplate();
        };

        CustomActionConfigVM.prototype.OnTemplateLoaded = function () {
        };

        CustomActionConfigVM.prototype.AfterRender = function (elements, data) {
        };

		CustomActionConfigVM.prototype.CreateObservableProperty = function (propertyName, onSubscribe) {
            this[propertyName] = ko.observable(this.ActionData[propertyName]);
            this[propertyName].subscribe(function (val) {
                onSubscribe(val);
            });
        };

        CustomActionConfigVM.prototype.MapPropertyToObservable = function (propertyName) {
            var _this = this;
            this.CreateObservableProperty(propertyName, function (val) {
                _this.ActionData[propertyName] = val;
            });
        };

        CustomActionConfigVM.prototype.ShouldBeLastAction = function () {
            return false;
        };
        CustomActionConfigVM.prototype.GetLastActionText = function () {
            return "";
        };
        return CustomActionConfigVM;
    }());
    exports.CustomActionConfigVM = CustomActionConfigVM;
});

define("sbExecuteCustomLogicExecutor", ["require", "exports", "knockout", "sbLoadingNotification", "sbStatus", "sbStatusColors"], function (require, exports, ko, LoadingNotification_1, Status_1, StatusColors_2) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CustomActionExecutor = /** @class */ (function () {
        function CustomActionExecutor(actionData, evaluator) {
            this.ActionData = actionData;
            this.evaluator = evaluator;
            this.loadingNotification = new LoadingNotification_1.LoadingNotification();
            this.isValid = function () {
                return true;
            };
            return this;
        }
        CustomActionExecutor.prototype.ExecuteAction = function (actionCompletedCallback) {
            var _this = this;
            var actionData = this.ActionData;
            var props = ['Message'];
            this.EvaluateProperties(props, function (evaluatedValues) {
                if (!actionCompletedCallback) {
                    actionCompletedCallback = function () { };
                }
                _this.ExecuteActionInternal(evaluatedValues['Message']);
                actionCompletedCallback();   
            });
        };

        CustomActionExecutor.prototype.ExecuteActionInternal = function (message) {
            //Custom logic goes here
            alert("Custom action executed! Data: " + message);
        };

        CustomActionExecutor.prototype.EvaluateProperties = function (props, completedcallback) {
            var _this = this;
            var evaluatedVals = {};
            for (var i = 0; i < props.length; i++) {
                var fullPropPath = props[i];
                this.EvaluateProperty(fullPropPath, function (propPath, val) {
                    evaluatedVals[propPath] = val;
                    if (_this.CheckEvaluated(props)) {
                        try {
                            completedcallback(evaluatedVals);
                        }
                        catch (err) {
                            _this.HandleError(completedcallback, err.name, err.message);
                        }
                    }
                });
            }
        };
        CustomActionExecutor.prototype.EvaluateProperty = function (propfullPath, completedCallback) {
            var _this = this;
            var data = this.ActionData;
            var propalias = propfullPath.replace('.', '_') + '_Evaluated';
            var props = propfullPath.split('.');
            while (props.length > 1) {
                data = data[props[0]];
                props.splice(0, 1);
            }
            var prop = propfullPath.substring(propfullPath.lastIndexOf('.') + 1);
            if (data[prop] && data[prop] != '') {
                _this.evaluator.EvaluateExpression(data[prop], function (val) {
                    _this[propalias] = true;
                    completedCallback(propfullPath, val);
                }, function (e) {
                    var message = typeof e == "string"
                        ? e
                        : SP.Utilities.HttpUtility.htmlEncode(e.name)
                            + ((e.message) ? "<br/>" + SP.Utilities.HttpUtility.htmlEncode(e.message).replace(/\n/g, '<br />') : "");
                    var statusMessageID = SP.UI.Status.addStatus('Failed evaluate property "' + prop + '" in  "' + _this.ActionData.Title + '":', message, false);
                    SP.UI.Status.setStatusPriColor(statusMessageID, 'red');
                    _this.loadingNotification.Remove();
                });
            }
            else {
                this[propalias] = true;
                completedCallback(propfullPath, data[prop]);
            }
        };
        CustomActionExecutor.prototype.CheckEvaluated = function (props) {
            var evalcount = 0;
            for (var i = 0; i < props.length; i++) {
                var propalias = props[i].replace('.', '_') + '_Evaluated';
                if (this[propalias])
                    evalcount++;
            }
            return evalcount == props.length;
        };
        CustomActionExecutor.prototype.HandleError = function (completedCallback, name, details) {
            if (name) {
                var status = new Status_1.Status('Failed to execute action "' + this.ActionData.Title + '" :', SP.Utilities.HttpUtility.htmlEncode(name) + ((details) ? "<br/>" + SP.Utilities.HttpUtility.htmlEncode(details).replace(/\n/g, '<br />') : ""), false);
                status.SetColor(StatusColors_2.StatusColors.red);
                status.Show();
            }
            this.loadingNotification.Show();
        };

        return CustomActionExecutor;
    }());
    exports.CustomActionExecutor = CustomActionExecutor;
});

define("sbExecuteCustomLogicAction", ["require", "exports", "sbExecuteCustomLogicConfigVM", "sbExecuteCustomLogicExecutor"], function (require, exports, CustomActionConfigVM, CustomActionExecutor) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CustomActionActionData = /** @class */ (function () {
        function CustomActionActionData() {
            var _this = this;
			 _this.IsSharedAction = true;
            _this.AppUniqueName = "sbExecuteCustomLogic";
            this.isValid = function () {
                return true;
            }
            return this;
        }

        CustomActionActionData.prototype.GetConfigVM = function () {
           return new CustomActionConfigVM.CustomActionConfigVM(this);
        };

        CustomActionActionData.prototype.GetExecutor = function (evaluator) {
            return new CustomActionExecutor.CustomActionExecutor(this, evaluator);
        };

        CustomActionActionData.prototype.GetActionTypeResource = function () {
            return "Custom Action";
        };

        CustomActionActionData.prototype.GetAlias = function () {
            return "CUSTOM_ACTION";
        };

        CustomActionActionData.prototype.IsActionEnabled = function () {
            return true;
        };

        CustomActionActionData.prototype.GetAvailableControlModes = function () {
            return [SPClientTemplates.ClientControlMode.NewForm, SPClientTemplates.ClientControlMode.DisplayForm, SPClientTemplates.ClientControlMode.EditForm];
        };
        return CustomActionActionData;
    }());
    exports.default = CustomActionActionData;
});

