
function Load-Prerequisition($isSPOnline){
    if($isSPOnline){
        Write-Host "Checking for SharePointPnPPowerShellOnline module..."
        if (-not (Get-Module -ListAvailable -Name SharePointPnPPowerShellOnline)) 
        {
            Write-Host "Installing SharePointPnPPowerShellOnline module..."
            Install-Module SharePointPnPPowerShellOnline
            Write-Host "SharePointPnPPowerShellOnline module has been installed"
        }
        else{
            Write-Host "SharePointPnPPowerShellOnline module is installed"
        }
        Import-Module SharePointPnPPowerShellOnline
    }
    else{
        Write-Host "Checking for SharePointPnPPowerShell2019 module..."
        if (-not (Get-Module -ListAvailable -Name SharePointPnPPowerShell2019)) 
        {
            Write-Host "Installing SharePointPnPPowerShell2019 module..."
            Install-Module SharePointPnPPowerShell2019
            Write-Host "SharePointPnPPowerShell2019 module has been installed"
        }
        else{
            Write-Host "SharePointPnPPowerShell2019 module is installed"
        }
        Import-Module SharePointPnPPowerShell2019
    }
}

function ConnectToSPOnline([string]$message, $isSPOnline){
    $weburl = Read-Host -Prompt $message
    if($isSPOnline){
        Write-Host "Connecting to SharePoint Online..."
    }
    else {
        Write-Host "Connecting to SharePoint 2019..."
    }
    Connect-PnPOnline -Url $weburl
    $web = Get-PnPWeb
    if( !$web ){
        Write-Error -Message "Failed to connect to SharePoint site." -ErrorAction Continue
        Read-Host -Prompt "Press Enter to quit..."
        exit 0
    }
    return $web;
}

function Get-ModernForms-CustomAction(){
    $action = Get-PnPCustomAction | Where-Object { $_.ClientSideComponentId -eq $ModernFormsCustomActionComponentId }
    return $action
}

function Add-ModernForms-CustomAction(){
    $action = Add-PnPCustomAction -
    $action = Get-PnPCustomAction | Where-Object { $_.ClientSideComponentId -eq $ModernFormsCustomActionComponentId }
    return $action
}

function Get-ModernForms-CustomAction-Props(){
    $action = Get-ModernForms-CustomAction
        
    if(!$action.Name){
        Write-Host Modern Forms Action does not exist. Please install skybow Moderns Forms add-in and customize sharePoint list. -ForegroundColor Red
    }
    else{
        $props = ConvertFrom-Json $action.ClientSideComponentProperties
        if($props.Enabled){
            return $props;
        }
    }
    return $null;
}

function Update-ModernForms-CustomAction-Props($props){
    $action = Get-ModernForms-CustomAction
    $action.ClientSideComponentProperties = ConvertTo-Json $props
    $action.Update()
    Invoke-PnPQuery
    
}

function TokenizeString( [string]$content, $list){
    $ListName =Get-ListName -list $list
    $content = $content.Replace($list.Id, '{listid_'+$ListName+'}')
    $content = $content.Replace($list.RootFolder.ServerRelativeUrl, '{list_url:' + $ListName + '}')
    return $content;
}
function UnTokenizeString( [string]$content, $list){
    $ListName =Get-ListName -list $list
    $content = $content.Replace('{listid_'+$ListName+'}', $list.Id)
    $content = $content.Replace('{list_url:' + $ListName + '}', $list.RootFolder.ServerRelativeUrl)
    return $content;
}

function Get-FileName( [string]$path ){
    $fileName = $path.Substring($path.LastIndexOfAny("/\".ToCharArray())+1)
    return $fileName;
}

function Get-ListName( $list ){    
    return Get-FileName -path $list.RootFolder.ServerRelativeUrl;
}

function Prompt-GetIsSharePointOnline()
{
    $choices = New-Object Collections.ObjectModel.Collection[Management.Automation.Host.ChoiceDescription]
    $choices.Add((New-Object Management.Automation.Host.ChoiceDescription -ArgumentList '&SharePoint OnLine'))
    $choices.Add((New-Object Management.Automation.Host.ChoiceDescription -ArgumentList 'Share&Point 2019'))
    $decision = $Host.UI.PromptForChoice('Confirmation', 'Select SharePoint environment: SharePoint Online or SharePoint Server 2019?', $choices, 0)

    $isOnline = 0 -eq $decision
    return $isOnline
}