﻿[CmdletBinding()]
    param(
        [nullable[bool]] $IsSPOnline
    )

. .\utils.ps1

$LocalPath = ".\export"

$ModernFormsCustomActionComponentId = 'd110e6ba-3612-4fd4-8b34-231a7f771d18'
$ConfigurationStorageLib = 'mFormsStoreLibrary'
$ConfigurationStorageFolder = $ConfigurationStorageLib + '/Configuration/Customization/'

if( $null -eq $IsSPOnline )
{
    $IsSPOnline = Prompt-GetIsSharePointOnline
}
Load-Prerequisition -isSPOnline $IsSPOnline
Write-Host "-------------------------------------------------------------------" -ForegroundColor White
$web = ConnectToSPOnline -message 'Enter site URL from which you want to export Modern Forms customization' -isSPOnline $IsSPOnline

function Export-ListCustomization($list){
    Write-Host Exporting $list.Title forms customization...
    $ListId = $list.Id;    
    $ListName = Get-ListName -list $list
    $LocalFolderPath = $LocalPath + '\' + $ListName
    $LocalFormsFolderPath = $LocalFolderPath + "\Forms"
    $LocalListConfigurationFilePath = $LocalFolderPath+"\configuration.json"    
    
    $props = Get-ModernForms-CustomAction-Props    
    $forms = $props.Forms;
    $listForms = $props.Forms | Where-Object { $_.ListId -eq $ListId -and $_.Enabled  }    
    try {
        New-Item -ItemType Directory -Force -Path $LocalFormsFolderPath | Out-Null
    }
    catch {
        Write-Error -Message "Unable to create directory '$LocalFormsFolderPath'. Error was: $_" -ErrorAction Stop
    }
    
    foreach( $form in $listForms ){
        $formName = Get-FileName -path $form.FormUrl
        $form.FormUrl = TokenizeString -content $form.FormUrl -list $list
        $form.ListId = TokenizeString -content $form.ListId -list $list
                        
        $filePath = $web.ServerRelativeUrl + $ConfigurationStorageFolder + $ListId + "_" + $formName + ".json";
        Get-PnPFile -Url $filePath -AsFile -Path $LocalFormsFolderPath -Filename ($formName + ".json") -Force -ErrorAction Ignore
    }

    $newActionProps = @{Forms = $listForms}
    ConvertTo-Json $newActionProps | Out-File ( New-Item -Path $LocalListConfigurationFilePath -Force )            
    Write-Host $list.Title list forms customization has been successfuly exported  to $LocalFolderPath -ForegroundColor Green    
}

if($web){
    $ListIDsOrTitles = Read-Host -Prompt "Please enter comma-separated list IDs or Titles (left empty in order to export all lists customization)"

    $arrListIDsOrTitles = $ListIDsOrTitles.Split(',');
    if(!$ListIDsOrTitles){
        $props = Get-ModernForms-CustomAction-Props
        if($props){    
            $arrListIDsOrTitles = $props.Forms | Select-Object -Property "ListId" -ExpandProperty "ListId" -Unique        
        }
    }


    foreach( $listIdOrTitle in $arrListIDsOrTitles){
        $listIdOrTitle = $listIdOrTitle.Trim();    
        if($listIdOrTitle) {
            $list = Get-PnPList -Identity $listIdOrTitle
            if(!$list.Title) {            
                Write-Host $listIdOrTitle - List not exist! -ForegroundColor Red
            }  
            else{  
                Export-ListCustomization -list $list
            } 
        }
    }
}

Read-Host -Prompt "Press Enter to quit..."