var csomapi = require('csom-node');

module.exports = function (azureContext, req) {

  // Granting access using SharePoint App-Only: https://docs.microsoft.com/en-us/sharepoint/dev/solution-guidance/security-apponly-azureacs
  var settings = {
    url: "https://m365x29123798.sharepoint.com/",
    appClientId: "APP-CLIENT-ID",
    appClientSecret: "APP-CLIENT-SECRET"
  };

  var SITE_URL = req.query["siteurl"]// absolute or server-relative URL to SharePoint site that contains a list with skybow Data Lookup column. Example "/sites/sitecollection1/deployment1" . We read this value from query string.
  var LIST_TITLE = "ListWithLookups"; //List title which contains skybow DataLookup field
  var FIELD_DATALOOKUP_NAME = "sbDataLookup"; //InternalName of skybow DataLookup field      
    
  var SOURCE_SITE_URL = "/sites/testsite"; //Absolute URL or server-relative URL of the source site, that contains source list with items for datalookup field
  var SOURCe_LIST_TITLE = "SourceList2"; //Source list Title
  var SOURCE_FIELD_NAME = "Title"; //Internal Name of display field  

  if(!SITE_URL){
    azureContext.log('An error occured: query string has missing [siteurl] parameter');
      azureContext.res = { status: 500, body: "Error!" };
      azureContext.done();
      return;
  }
  
  azureContext.log(`Start fixing data lookup column "${FIELD_DATALOOKUP_NAME}" of "${LIST_TITLE}" list in "${SITE_URL}" site...`);

  csomapi.setLoaderOptions({ url: settings.url });
  var authCtx = new AuthenticationContext(settings.url);
  
  //authCtx.acquireTokenForUser(settings.username, settings.password, (err, data) => {
  authCtx.acquireTokenForApp(settings.appClientId, settings.appClientSecret, (err, data) => {

    var loadSourceDataConnection = () => {
      return new Promise((resolve, reject) => {
        var sourceCtx = new SP.ClientContext(SOURCE_SITE_URL);
        authCtx.setAuthenticationCookie(sourceCtx); // authanticate
        var sourceWeb = sourceCtx.get_web();
        var sourceList = sourceWeb.get_lists().getByTitle(SOURCe_LIST_TITLE);
        var sourceListFolder = sourceList.get_rootFolder();

        sourceCtx.load(sourceWeb);
        sourceCtx.load(sourceList);
        sourceCtx.load(sourceListFolder);
        sourceCtx.executeQueryAsync(() => {
          var listUrl = sourceListFolder.get_serverRelativeUrl();
          var listWebRelativeUrl = listUrl.substring(sourceWeb.get_serverRelativeUrl().length);
          if ('/' == listWebRelativeUrl[0]) {
            listWebRelativeUrl = listWebRelativeUrl.substring(1);
          }
          var SOURCE_DataConnection = {
            "DataSourceType": "SharePointList",
            "SiteUrl": sourceWeb.get_serverRelativeUrl(),
            "LookupListUrl": listWebRelativeUrl,
            "LookupListId": sourceList.get_id().toString(),
            "DisplayField": SOURCE_FIELD_NAME,
          }
          resolve(SOURCE_DataConnection);
        }, (sender, args) => {
          reject("Cannot load source list: " + args.get_message());
        });
      });
    }

    var updateDataLookupConnection = () => {
      return new Promise((resolve, reject) => {
        var ctx = new SP.ClientContext(SITE_URL);
        authCtx.setAuthenticationCookie(ctx); // authanticate
        var list = ctx.get_web().get_lists().getByTitle(LIST_TITLE)
        var fieldDataLookup = list.get_fields().getByInternalNameOrTitle(FIELD_DATALOOKUP_NAME);
        ctx.load(fieldDataLookup)
        ctx.executeQueryAsync(() => {
          var props = null;
          try {
            var strProps = fieldDataLookup.get_clientSideComponentProperties()
            var props = JSON.parse(strProps);
            if (!props || !props.SkybowDataConnector) {
              throw "This is not skybow Data Lookup field.";
            }

          }
          catch (ex) {
            reject("Cannot load skybow Data Lookup properties. " + ex);
            return;
          }
          if (props) {
            var dataConnection = props.DataConnection;
            if (dataConnection) {
              azureContext.log("Old Data Connection of '" + fieldDataLookup.get_internalName() + "' field: " + JSON.stringify(dataConnection));
            }

            loadSourceDataConnection().then(newDataSource => {
              props.DataConnection = newDataSource;
              fieldDataLookup.set_clientSideComponentProperties(JSON.stringify(props));
              fieldDataLookup.update();
              ctx.executeQueryAsync(() => {                
                azureContext.log("New Data Connection of '" + fieldDataLookup.get_internalName() + "' field: " + JSON.stringify(newDataSource));
                azureContext.log("skybow Data Lookup field has been updated successfully");
                resolve();
              }, (sender, args) => {
                reject("Unexpected error occurred during updating skybow Data Lookup: " + args.get_message());
              });
            }).catch(reject);
          }
        }, function (sender, args) {
          reject("Cannot load skybow Data Lookup: " + args.get_message());
        });
      })
    }

    updateDataLookupConnection().then(() => {
      azureContext.res = { body: "Success!" };
      azureContext.done();
    }).catch(error => {
      azureContext.log('An error occured: ' + error);
      azureContext.res = { status: 500, body: "Error!" };
      azureContext.done();
    });

  });
}